/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jul;

import io.sentry.Sentry;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.MessageInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.slf4j.MDC;

public class SentryHandler
extends Handler {
    public static final String THREAD_ID = "Sentry-ThreadId";
    protected boolean printfStyle;

    public SentryHandler() {
        this.retrieveProperties();
        this.setFilter(new DropSentryFilter());
    }

    protected static Event.Level getLevel(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return Event.Level.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return Event.Level.WARNING;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return Event.Level.INFO;
        }
        if (level.intValue() >= Level.ALL.intValue()) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> formattedParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            formattedParameters.add(parameter != null ? parameter.toString() : null);
        }
        return formattedParameters;
    }

    protected void retrieveProperties() {
        LogManager manager = LogManager.getLogManager();
        String className = SentryHandler.class.getName();
        this.setPrintfStyle(Boolean.valueOf(manager.getProperty(className + ".printfStyle")));
        this.setLevel(this.parseLevelOrDefault(manager.getProperty(className + ".level")));
    }

    private Level parseLevelOrDefault(String levelName) {
        try {
            return Level.parse(levelName.trim());
        }
        catch (Exception e) {
            return Level.WARNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            EventBuilder eventBuilder = this.createEventBuilder(record);
            Sentry.capture(eventBuilder);
        }
        catch (Exception e) {
            this.reportError("An exception occurred while creating a new event in Sentry", e, 1);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    protected EventBuilder createEventBuilder(LogRecord record) {
        Map<String, String> mdc;
        EventBuilder eventBuilder = new EventBuilder().withSdkIntegration("java.util.logging").withLevel(SentryHandler.getLevel(record.getLevel())).withTimestamp(new Date(record.getMillis())).withLogger(record.getLoggerName());
        String message = record.getMessage();
        if (record.getResourceBundle() != null && record.getResourceBundle().containsKey(record.getMessage())) {
            message = record.getResourceBundle().getString(record.getMessage());
        }
        String topLevelMessage = message;
        if (record.getParameters() == null) {
            eventBuilder.withSentryInterface(new MessageInterface(message));
        } else {
            String formatted;
            List<String> parameters = SentryHandler.formatMessageParameters(record.getParameters());
            try {
                topLevelMessage = formatted = this.formatMessage(message, record.getParameters());
            }
            catch (Exception e) {
                formatted = null;
            }
            eventBuilder.withSentryInterface(new MessageInterface(message, parameters, formatted));
        }
        eventBuilder.withMessage(topLevelMessage);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            eventBuilder.withSentryInterface(new ExceptionInterface(throwable));
        }
        if ((mdc = MDC.getMDCAdapter().getCopyOfContextMap()) != null) {
            for (Map.Entry<String, String> mdcEntry : mdc.entrySet()) {
                if (Sentry.getStoredClient().getMdcTags().contains(mdcEntry.getKey())) {
                    eventBuilder.withTag(mdcEntry.getKey(), mdcEntry.getValue());
                    continue;
                }
                eventBuilder.withExtra(mdcEntry.getKey(), mdcEntry.getValue());
            }
        }
        eventBuilder.withExtra(THREAD_ID, record.getThreadID());
        return eventBuilder;
    }

    protected String formatMessage(String message, Object[] parameters) {
        String formatted = this.printfStyle ? String.format(message, parameters) : MessageFormat.format(message, parameters);
        return formatted;
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SecurityException {
        SentryEnvironment.startManagingThread();
        try {
            Sentry.close();
        }
        catch (Exception e) {
            this.reportError("An exception occurred while closing the Sentry connection", e, 3);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    public void setPrintfStyle(boolean printfStyle) {
        this.printfStyle = printfStyle;
    }

    private class DropSentryFilter
    implements Filter {
        private DropSentryFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String loggerName = record.getLoggerName();
            return loggerName == null || !loggerName.startsWith("io.sentry");
        }
    }
}

