/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import org.hibernate.bytecode.enhance.internal.javassist.MethodWriter;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.maxgamer.javax.persistence.Transient;

public class FieldWriter {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(FieldWriter.class);

    private FieldWriter() {
    }

    public static void addField(CtClass target, CtClass type, String field) {
        FieldWriter.addPrivateTransient(target, type, field);
    }

    public static void addFieldWithGetterAndSetter(CtClass target, CtClass type, String field, String getter, String setter) {
        FieldWriter.addPrivateTransient(target, type, field);
        MethodWriter.addGetter(target, field, getter);
        MethodWriter.addSetter(target, field, setter);
    }

    private static void addPrivateTransient(CtClass target, CtClass type, String name) {
        FieldWriter.addWithModifiers(target, type, name, 130, Transient.class);
        log.debugf("Wrote field into [%s]: @Transient private transient %s %s;", (Object)target.getName(), (Object)type.getName(), (Object)name);
    }

    private static void addWithModifiers(CtClass target, CtClass type, String name, int modifiers, Class<?> ... annotations) {
        try {
            CtField f = new CtField(type, name, target);
            f.setModifiers(f.getModifiers() | modifiers);
            FieldWriter.addAnnotations(f.getFieldInfo(), annotations);
            target.addField(f);
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance class [%s] to add field [%s]", target.getName(), name);
            throw new EnhancementException(msg, cce);
        }
    }

    private static void addAnnotations(FieldInfo fieldInfo, Class<?>[] annotations) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
            fieldInfo.addAttribute(annotationsAttribute);
        }
        for (Class<?> annotation : annotations) {
            annotationsAttribute.addAnnotation(new Annotation(annotation.getName(), fieldInfo.getConstPool()));
        }
    }
}

