/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.AbstractManagedType;
import org.hibernate.metamodel.internal.AttributeImplementor;
import org.maxgamer.javax.persistence.metamodel.Attribute;
import org.maxgamer.javax.persistence.metamodel.ManagedType;

public abstract class AbstractAttribute<X, Y>
implements Attribute<X, Y>,
AttributeImplementor<X, Y>,
Serializable {
    private final String name;
    private final Class<Y> javaType;
    private final AbstractManagedType<X> declaringType;
    private transient Member member;
    private final Attribute.PersistentAttributeType persistentAttributeType;

    public AbstractAttribute(String name, Class<Y> javaType, AbstractManagedType<X> declaringType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
        this.name = name;
        this.javaType = javaType;
        this.declaringType = declaringType;
        this.member = member;
        this.persistentAttributeType = persistentAttributeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ManagedType<X> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Class<Y> getJavaType() {
        return this.javaType;
    }

    @Override
    public Member getJavaMember() {
        return this.member;
    }

    @Override
    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String memberDeclaringClassName = (String)ois.readObject();
        String memberName = (String)ois.readObject();
        String memberType = (String)ois.readObject();
        Class<?> memberDeclaringClass = Class.forName(memberDeclaringClassName, false, this.declaringType.getJavaType().getClassLoader());
        try {
            this.member = "method".equals(memberType) ? memberDeclaringClass.getMethod(memberName, ReflectHelper.NO_PARAM_SIGNATURE) : memberDeclaringClass.getField(memberName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to locate member [" + memberDeclaringClassName + "#" + memberName + "]");
        }
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getJavaMember().getDeclaringClass().getName());
        oos.writeObject(this.getJavaMember().getName());
        oos.writeObject(Method.class.isInstance(this.getJavaMember()) ? "method" : "field");
    }
}

