/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal.expression;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.ParameterRegistry;
import org.hibernate.query.criteria.internal.PathImplementor;
import org.hibernate.query.criteria.internal.Renderable;
import org.hibernate.query.criteria.internal.compile.RenderingContext;
import org.hibernate.query.criteria.internal.expression.ExpressionImpl;
import org.maxgamer.javax.persistence.criteria.Expression;
import org.maxgamer.javax.persistence.metamodel.MapAttribute;

public class MapEntryExpression<K, V>
extends ExpressionImpl<Map.Entry<K, V>>
implements Expression<Map.Entry<K, V>>,
Serializable {
    private final PathImplementor origin;
    private final MapAttribute<?, K, V> attribute;

    public MapEntryExpression(CriteriaBuilderImpl criteriaBuilder, Class<Map.Entry<K, V>> javaType, PathImplementor origin, MapAttribute<?, K, V> attribute) {
        super(criteriaBuilder, javaType);
        this.origin = origin;
        this.attribute = attribute;
    }

    public MapAttribute<?, K, V> getAttribute() {
        return this.attribute;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
    }

    @Override
    public String render(RenderingContext renderingContext) {
        throw new IllegalStateException("illegal reference to map entry outside of select clause.");
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return "entry(" + this.path(renderingContext) + ")";
    }

    private String path(RenderingContext renderingContext) {
        return this.origin.getPathIdentifier() + '.' + ((Renderable)((Object)this.getAttribute())).renderProjection(renderingContext);
    }
}

