/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans;

import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.event.Event;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.maxgamer.maxbans.config.PluginConfig;
import org.maxgamer.maxbans.context.PluginContext;
import org.maxgamer.maxbans.context.component.CommandExecutorComponent;
import org.maxgamer.maxbans.exception.ConfigException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.exception.SchemaBrokenException;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.transaction.TransactionLayer;
import org.maxgamer.maxbans.util.FlywayUtil;
import org.maxgamer.maxbans.util.SentryLogger;

public class MaxBansPlus
extends JavaPlugin {
    private Locale locale = new Locale();
    private PluginContext context;
    private File messagesFile;
    private Logger sentryLogger;

    public void onLoad() {
        Logger.getLogger("org.hibernate").setLevel(Level.SEVERE);
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
    }

    public void saveDefaultConfig() {
        super.saveDefaultConfig();
        if (!this.messagesFile.exists()) {
            this.saveResource(this.messagesFile.getName(), false);
        }
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.context != null) {
            try {
                this.context.getConfig().load((Configuration)this.getConfig(), this.getServer());
            }
            catch (ConfigException e) {
                this.getLogger().severe("Configuration failed validation at " + e.getSection().getCurrentPath() + ": " + e.getMessage());
                this.getPluginLoader().disablePlugin((Plugin)this);
                return;
            }
        }
        YamlConfiguration localeConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource("messages.yml")));
        try {
            localeConfig.load((Reader)new FileReader(this.messagesFile));
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't read file: " + this.messagesFile, e);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalStateException("Bad YML configuration file: " + this.messagesFile, e);
        }
        this.locale.load((ConfigurationSection)localeConfig);
    }

    public void migrate() {
        Flyway flyway = FlywayUtil.migrater(this.context.getConfig().getJdbcConfig());
        flyway.migrate();
    }

    public void onEnable() {
        PluginConfig config;
        this.saveDefaultConfig();
        this.reloadConfig();
        try {
            config = new PluginConfig((Configuration)this.getConfig(), this.getServer());
        }
        catch (ConfigException e) {
            this.getLogger().severe("Configuration failed validation at " + e.getSection().getCurrentPath() + ": " + e.getMessage());
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (config.isErrorTracking()) {
            SentryClient client = Sentry.init("https://34922284faf14712b3a75f86c883349e:18ac8a9a9d6e4dc1a8265daf47d0e223@sentry.io/171230");
            this.sentryLogger = new SentryLogger(this, Event.Level.WARNING, client);
        }
        this.context = new PluginContext(this, config, this.locale, this.getServer(), this.getDataFolder(), this.getErrorLogger(), this.getServer().getPluginManager());
        try {
            this.migrate();
        }
        catch (OverlappingFileLockException e) {
            this.getLogger().log(Level.SEVERE, "Database file is locked. Perhaps another server is running from the same directory. Disabling MaxBans", e);
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        catch (SchemaBrokenException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage());
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        catch (FlywayException e) {
            this.getErrorLogger().log(Level.SEVERE, "Unable to migrate database. Disabling MaxBans", e);
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        this.register(this.context.components().listeners().restriction());
        CommandExecutorComponent commands = this.context.components().commands();
        this.register("ban", commands.ban());
        this.register("ipban", commands.ipban());
        this.register("unban", commands.unban());
        this.register("mute", commands.mute());
        this.register("ipmute", commands.ipmute());
        this.register("unmute", commands.unmute());
        this.register("iplookup", commands.lookup());
        this.register("kick", commands.kick());
        this.register("warn", commands.warn());
        this.register("lockdown", commands.lockdown());
        this.register("history", commands.history());
        try (TransactionLayer tx = this.context.components().transactor().transact();){
            for (Player player : this.context.getServer().getOnlinePlayers()) {
                try {
                    this.context.components().listeners().restriction().onJoin(player, player.getAddress().getAddress().getHostAddress());
                }
                catch (RejectedException e) {
                    player.kickPlayer(e.getMessage(this.locale));
                }
            }
        }
    }

    private void register(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    private void register(String name, CommandExecutor command) {
        this.getCommand(name).setExecutor(command);
    }

    public void onDisable() {
        if (this.context != null) {
            this.context.close();
        }
    }

    public PluginContext getContext() {
        return this.context;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Logger getErrorLogger() {
        if (this.sentryLogger == null) {
            return this.getLogger();
        }
        return this.sentryLogger;
    }
}

