/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.time.Duration;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.command.UserRestrictionCommandExecutor;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.service.metric.MetricService;
import org.maxgamer.maxbans.util.TemporalDuration;

public class BanCommandExecutor
extends UserRestrictionCommandExecutor {
    private BroadcastService broadcastService;
    private UserService userService;
    private MetricService metricService;

    @Inject
    public BanCommandExecutor(BroadcastService broadcastService, UserService userService, MetricService metricService) {
        super("maxbans.ban");
        this.broadcastService = broadcastService;
        this.userService = userService;
        this.metricService = metricService;
    }

    @Override
    public void restrict(CommandSender source, User user, Duration duration, String reason, boolean silent) throws RejectedException, CancelledException {
        User banner = source instanceof Player ? this.userService.getOrCreate((Player)source) : null;
        this.userService.ban(banner, user, reason, duration);
        MessageBuilder message = this.locale.get().with("name", user.getName()).with("reason", reason).with("source", banner == null ? "Console" : banner.getName()).with("duration", TemporalDuration.of(duration));
        Player player = this.locatorService.player(user);
        if (player != null) {
            player.kickPlayer(message.get("ban.kick"));
        }
        this.broadcastService.broadcast(message.get("ban.broadcast"), silent, new CommandSender[]{source, player});
        this.metricService.increment("user_bans");
    }
}

