/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.maxgamer.maxbans.command.StandardCommandExecutor;
import org.maxgamer.maxbans.exception.MessageException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.HistoryService;
import org.maxgamer.maxbans.service.UserService;

public class HistoryCommandExecutor
extends StandardCommandExecutor {
    @Inject
    protected UserService userService;
    @Inject
    protected HistoryService historyService;

    @Inject
    public HistoryCommandExecutor() {
        super("maxbans.history");
    }

    @Override
    public void perform(CommandSender sender, Command command, String cmd, String[] userArgs) throws MessageException {
        List<String> messages;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(userArgs));
        int page = 0;
        if (!args.isEmpty()) {
            User user;
            String banner = args.remove(0);
            if (banner.equalsIgnoreCase("console")) {
                user = null;
            } else {
                user = this.userService.get(banner + "%");
                if (user == null) {
                    throw new RejectedException("User " + banner + " doesn't exist");
                }
            }
            if (!args.isEmpty()) {
                String pageString = args.remove(0);
                try {
                    page = Integer.parseInt(pageString) - 1;
                    if (page < 0) {
                        throw new RejectedException("Page number must be >= 1");
                    }
                }
                catch (NumberFormatException e) {
                    throw new RejectedException(pageString + " is not a suitable page number");
                }
            }
            messages = this.historyService.getHistory(page, user);
        } else {
            messages = this.historyService.getHistory(page);
        }
        for (String message : messages) {
            sender.sendMessage(message);
        }
        sender.sendMessage("--- Page " + (page + 1) + " ---");
    }
}

