/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.util.Arrays;
import java.util.LinkedList;
import javax.inject.Inject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.command.StandardCommandExecutor;
import org.maxgamer.maxbans.exception.MessageException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.LockdownService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.util.Lockdown;
import org.maxgamer.maxbans.util.RestrictionUtil;

public class LockdownCommandExecutor
extends StandardCommandExecutor {
    @Inject
    protected LockdownService lockdownService;
    @Inject
    protected UserService userService;
    @Inject
    protected BroadcastService broadcastService;

    @Inject
    public LockdownCommandExecutor() {
        super("maxbans.lockdown");
    }

    @Override
    public void perform(CommandSender sender, Command command, String name, String[] userArgs) throws MessageException {
        User source = sender instanceof Player ? this.userService.getOrCreate((Player)sender) : null;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(userArgs));
        boolean silent = RestrictionUtil.isSilent(args);
        if (args.size() <= 0) {
            throw new RejectedException("Must supply a type of lockdown to apply: " + Arrays.toString((Object[])Lockdown.values()));
        }
        String type = args.pop();
        MessageBuilder message = this.lockdownService.lockdown(source, type, String.join((CharSequence)" ", args), this.locale);
        this.broadcastService.broadcast(message.get("lockdown.broadcast"), silent, sender);
    }
}

