/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.time.Duration;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.maxgamer.maxbans.command.IPRestrictionCommandExecutor;
import org.maxgamer.maxbans.exception.PermissionException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.UserService;

public class LookupCommandExecutor
extends IPRestrictionCommandExecutor {
    @Inject
    protected UserService userService;

    @Inject
    public LookupCommandExecutor() {
        super("maxbans.iplookup");
    }

    @Override
    public void restrict(CommandSender source, Address address, User user, Duration duration, String reason, boolean silent) throws RejectedException, PermissionException {
        String message;
        if (user != null) {
            message = this.userService.report(user, this.locale).get("iplookup.user");
            source.sendMessage(message);
        }
        source.sendMessage("-----------------------------------");
        message = this.addressService.report(address, this.locale).get("iplookup.ip");
        source.sendMessage(message);
    }
}

