/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import javax.inject.Inject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.maxgamer.maxbans.command.TransactionalCommandExecutor;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.MessageException;
import org.maxgamer.maxbans.exception.PermissionException;
import org.maxgamer.maxbans.locale.Locale;

public abstract class StandardCommandExecutor
extends TransactionalCommandExecutor {
    @Inject
    protected Locale locale;
    protected String permission;

    public StandardCommandExecutor(String permission) {
        this.permission = permission;
    }

    protected void permiss(CommandSender sender) throws PermissionException {
        if (!sender.hasPermission(this.permission)) {
            throw new PermissionException("permission.required").with("permission", this.permission);
        }
    }

    @Override
    public final void transact(CommandSender sender, Command command, String name, String[] args) {
        try {
            this.permiss(sender);
            this.perform(sender, command, name, args);
        }
        catch (PermissionException e) {
            e.with("permission", this.permission).send(this.locale, sender);
        }
        catch (MessageException e) {
            e.send(this.locale, sender);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public abstract void perform(CommandSender var1, Command var2, String var3, String[] var4) throws MessageException, CancelledException;
}

