/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.time.Duration;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.command.IPRestrictionCommandExecutor;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.service.metric.MetricService;

public class UnbanCommandExecutor
extends IPRestrictionCommandExecutor {
    @Inject
    protected BroadcastService broadcastService;
    @Inject
    protected UserService userService;
    @Inject
    protected MetricService metricService;

    @Inject
    public UnbanCommandExecutor() {
        super("maxbans.ban");
    }

    @Override
    public void restrict(CommandSender sender, Address address, User user, Duration duration, String reason, boolean silent) throws RejectedException, CancelledException {
        User source = sender instanceof Player ? this.userService.getOrCreate((Player)sender) : null;
        MessageBuilder message = this.locale.get().with("source", source == null ? "Console" : source.getName());
        boolean any = false;
        if (user != null && this.userService.getBan(user) != null) {
            this.userService.unban(source, user);
            message.with("name", user.getName());
            this.broadcastService.broadcast(message.get("ban.unban"), silent, sender);
            any = true;
        }
        if (this.addressService.getBan(address) != null) {
            this.addressService.unban(source, address);
            message.with("address", address.getHost());
            this.broadcastService.broadcast(message.get("ban.unban"), silent, sender);
            any = true;
        }
        if (!any) {
            throw new RejectedException("No ban found");
        }
    }
}

