/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import javax.inject.Inject;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.maxgamer.maxbans.command.StandardCommandExecutor;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.MessageException;
import org.maxgamer.maxbans.exception.PermissionException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.LocatorService;
import org.maxgamer.maxbans.transaction.TransactionLayer;
import org.maxgamer.maxbans.util.RestrictionUtil;

public abstract class UserRestrictionCommandExecutor
extends StandardCommandExecutor {
    @Inject
    protected LocatorService locatorService;

    public UserRestrictionCommandExecutor(String permission) {
        super(permission);
    }

    @Override
    public final void perform(CommandSender sender, Command command, String s, String[] userArgs) throws MessageException, CancelledException {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(userArgs));
        boolean silent = RestrictionUtil.isSilent(args);
        if (args.size() <= 0) {
            sender.sendMessage("Must supply target name");
            return;
        }
        try (TransactionLayer tx = this.transactor.transact();){
            User user = this.locatorService.user(args.pop());
            if (user == null) {
                sender.sendMessage("Player not found");
                return;
            }
            Duration duration = RestrictionUtil.getDuration(args);
            String reason = String.join((CharSequence)" ", args);
            this.restrict(sender, user, duration, reason, silent);
        }
    }

    public abstract void restrict(CommandSender var1, User var2, Duration var3, String var4, boolean var5) throws RejectedException, PermissionException, CancelledException;
}

