/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.command;

import java.time.Duration;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.command.UserRestrictionCommandExecutor;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.service.WarningService;
import org.maxgamer.maxbans.service.metric.MetricService;

public class WarnCommandExecutor
extends UserRestrictionCommandExecutor {
    @Inject
    protected UserService userService;
    @Inject
    protected WarningService warningService;
    @Inject
    protected BroadcastService broadcastService;
    @Inject
    protected MetricService metricService;

    @Inject
    public WarnCommandExecutor() {
        super("maxbans.warn");
    }

    @Override
    public void restrict(CommandSender source, User user, Duration duration, String reason, boolean silent) throws CancelledException {
        User banner = source instanceof Player ? this.userService.getOrCreate((Player)source) : null;
        MessageBuilder message = this.warningService.warn(banner, user, reason, this.locale);
        this.broadcastService.broadcast(message.get("warn.broadcast"), silent, new CommandSender[]{source, this.locatorService.player(user)});
        this.metricService.increment("warnings");
    }
}

