/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.config;

import org.bukkit.configuration.ConfigurationSection;

public class JdbcConfig {
    private String url;
    private String driver;
    private String username;
    private String password;
    private boolean showSql;

    public JdbcConfig() {
    }

    public JdbcConfig(ConfigurationSection section) {
        this.setUrl(section.getString("url", "jdbc:h2:mem:"));
        this.setDriver(section.getString("driver", "org.h2.Driver"));
        this.setUsername(section.getString("username", "root"));
        this.setPassword(section.getString("password", "password"));
        this.setShowSql(section.getBoolean("show-sql", false));
    }

    public String getDriver() {
        return this.driver;
    }

    public JdbcConfig setDriver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public JdbcConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public JdbcConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public JdbcConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public JdbcConfig setShowSql(boolean showSql) {
        this.showSql = showSql;
        return this;
    }

    public String toString() {
        return "JdbcConfig{url='" + this.url + '\'' + ", driver='" + this.driver + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", showSql=" + this.showSql + '}';
    }
}

