/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.configuration.Configuration;
import org.maxgamer.maxbans.config.JdbcConfig;
import org.maxgamer.maxbans.config.WarningConfig;
import org.maxgamer.maxbans.exception.ConfigException;

public class PluginConfig {
    private JdbcConfig jdbcConfig;
    private WarningConfig warningConfig;
    private boolean isOffline;
    private Set<String> chatCommands;
    private boolean errorTracking;
    private boolean metrics;

    public PluginConfig() {
        this.setJdbcConfig(new JdbcConfig());
        this.setWarningConfig(new WarningConfig());
        this.setOffline(false);
    }

    public PluginConfig(Configuration configuration, Server server) throws ConfigException {
        this.load(configuration, server);
    }

    public void load(Configuration configuration, Server server) throws ConfigException {
        this.setJdbcConfig(new JdbcConfig(configuration.getConfigurationSection("database")));
        this.setWarningConfig(new WarningConfig(configuration.getConfigurationSection("warnings")));
        this.setOffline(configuration.getBoolean("offline", !server.getOnlineMode()));
        this.setChatCommands(configuration.getStringList("chat-commands"));
        this.setErrorTracking(configuration.getBoolean("error-tracking", false));
        this.setMetrics(configuration.getBoolean("metrics", true));
    }

    public JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    public PluginConfig setJdbcConfig(JdbcConfig jdbcConfig) {
        this.jdbcConfig = jdbcConfig;
        return this;
    }

    public WarningConfig getWarningConfig() {
        return this.warningConfig;
    }

    public PluginConfig setWarningConfig(WarningConfig warningConfig) {
        this.warningConfig = warningConfig;
        return this;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public PluginConfig setOffline(boolean offline) {
        this.isOffline = offline;
        return this;
    }

    public Set<String> getChatCommands() {
        return this.chatCommands;
    }

    public void setChatCommands(Collection<String> chatCommands) {
        this.chatCommands = new HashSet<String>(chatCommands.size());
        for (String command : chatCommands) {
            if (command == null) continue;
            this.chatCommands.add(command.toLowerCase());
        }
    }

    public boolean isErrorTracking() {
        return this.errorTracking;
    }

    public void setErrorTracking(boolean errorTracking) {
        this.errorTracking = errorTracking;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public void setMetrics(boolean metrics) {
        this.metrics = metrics;
    }
}

