/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.maxgamer.maxbans.exception.ConfigException;
import org.maxgamer.maxbans.util.RestrictionUtil;

public class WarningConfig {
    private Map<Integer, List<String>> penalties = new HashMap<Integer, List<String>>();
    private int strikes = 3;
    private Duration duration = Duration.ofDays(7L);

    public WarningConfig() {
    }

    public WarningConfig(ConfigurationSection section) throws ConfigException {
        String timeString;
        Duration duration;
        int total;
        if (section == null) {
            return;
        }
        ConfigurationSection commands = section.getConfigurationSection("penalties");
        if (commands != null) {
            for (String key : commands.getKeys(false)) {
                LinkedList<String> value = new LinkedList<String>();
                if (commands.isList(key)) {
                    value.addAll(commands.getStringList(key));
                } else {
                    value.add(commands.getString(key));
                }
                try {
                    int strike = Integer.parseInt(key);
                    this.penalties.put(strike, value);
                    this.strikes = Math.max(strike, this.strikes);
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(commands, "Expected key to be an integer, got '" + key + "'");
                }
            }
        }
        if ((total = section.getInt("strikes", -1)) != -1) {
            if (total < this.strikes) {
                throw new ConfigException(section, "Number of strikes may not be less than the highest penalty strike");
            }
            this.strikes = total;
        }
        if ((duration = RestrictionUtil.getDuration(new LinkedList<String>(Arrays.asList((timeString = section.getString("duration", "7 days")).split(" "))))) == null) {
            throw new ConfigException(section, "Expected duration like '7 days' or '1 minute', but got '" + timeString + "'");
        }
    }

    public List<String> getPenalty(int strikes) {
        List<String> penalties = this.penalties.get(strikes);
        if (penalties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(penalties);
    }

    public void setPenalties(int strikes, List<String> commands) {
        this.penalties.put(strikes, commands);
    }

    public void setPenalties(int strikes, String ... commands) {
        this.setPenalties(strikes, Arrays.asList(commands));
    }

    public int getStrikes() {
        return this.strikes;
    }

    public void setStrikes(int strikes) {
        this.strikes = strikes;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }
}

