/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.context;

import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginManager;
import org.hibernate.SessionFactory;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.SessionFactoryImpl;
import org.maxgamer.maxbans.MaxBansPlus;
import org.maxgamer.maxbans.config.PluginConfig;
import org.maxgamer.maxbans.context.component.DaggerPluginComponent;
import org.maxgamer.maxbans.context.component.PluginComponent;
import org.maxgamer.maxbans.context.module.PluginModule;
import org.maxgamer.maxbans.locale.Locale;

public class PluginContext {
    private PluginConfig config;
    private Server server;
    private File dataFolder;
    private PluginComponent modules;
    private PluginModule pluginModule;

    public PluginContext(MaxBansPlus plugin, PluginConfig config, Locale locale, Server server, File dataFolder, Logger logger2, PluginManager pluginManager) {
        this.config = config;
        this.server = server;
        this.dataFolder = dataFolder;
        YamlConfiguration lockdownCfg = YamlConfiguration.loadConfiguration((File)new File(dataFolder, "lockdown.yml"));
        this.pluginModule = new PluginModule(plugin, server, config, (FileConfiguration)lockdownCfg, locale, logger2, pluginManager);
        this.modules = DaggerPluginComponent.builder().pluginModule(this.pluginModule).build();
    }

    public PluginModule getPluginModule() {
        return this.pluginModule;
    }

    public PluginComponent components() {
        return this.modules;
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public Server getServer() {
        return this.server;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public void close() {
        if (this.pluginModule.isSessionInitialised()) {
            SessionFactoryImpl sf;
            ConnectionProvider provider;
            SessionFactory factory = this.components().sessionFactory();
            if (factory instanceof SessionFactoryImpl && (provider = (sf = (SessionFactoryImpl)factory).getServiceRegistry().getService(ConnectionProvider.class)) instanceof C3P0ConnectionProvider) {
                ((C3P0ConnectionProvider)provider).stop();
            }
            factory.close();
        }
    }
}

