/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.exception;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.locale.MessageBuilder;

public class MessageException
extends Exception {
    private Map<String, Object> substitutions = new HashMap<String, Object>(6);

    public MessageException(String message) {
        super(message);
    }

    public MessageException with(String key, Object value) {
        this.substitutions.put(key, value);
        return this;
    }

    public void send(Locale locale, CommandSender sender) {
        sender.sendMessage(this.getMessage(locale));
    }

    public String getMessage(Locale locale) {
        if (locale.has(this.getMessage())) {
            MessageBuilder builder = this.toBuilder(locale);
            return builder.get(this.getMessage());
        }
        return super.getMessage();
    }

    public MessageBuilder toBuilder(Locale locale) {
        MessageBuilder builder = locale.get();
        for (Map.Entry<String, Object> entry : this.substitutions.entrySet()) {
            builder.with(entry.getKey(), entry.getValue());
        }
        return builder;
    }
}

