/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.listener;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.AddressService;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.LockdownService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.transaction.TransactionLayer;
import org.maxgamer.maxbans.transaction.Transactor;

public class RestrictionListener
implements Listener {
    private Transactor transactor;
    private UserService userService;
    private LockdownService lockdownService;
    private BroadcastService broadcastService;
    private AddressService addressService;
    private Locale locale;
    private Logger logger;

    @Inject
    public RestrictionListener(Transactor transactor, UserService userService, LockdownService lockdownService, BroadcastService broadcastService, AddressService addressService, Locale locale, Logger logger2) {
        this.transactor = transactor;
        this.userService = userService;
        this.lockdownService = lockdownService;
        this.broadcastService = broadcastService;
        this.addressService = addressService;
        this.locale = locale;
        this.logger = logger2;
    }

    public void onJoin(Player player, String address) throws RejectedException {
        User user = this.userService.getOrCreate(player);
        try {
            this.userService.onJoin(user);
        }
        catch (RejectedException r) {
            this.broadcastService.moderators("banned", Duration.ofMinutes(3L), r.toBuilder(this.locale).get("notification.banned"));
            throw r;
        }
        try {
            this.addressService.onJoin(user, address);
        }
        catch (RejectedException r) {
            this.broadcastService.moderators("banned", Duration.ofMinutes(3L), r.toBuilder(this.locale).get("notification.ipbanned"));
            throw r;
        }
        try {
            this.lockdownService.onJoin(user);
        }
        catch (RejectedException r) {
            this.broadcastService.moderators("lockdown", Duration.ofMinutes(3L), r.toBuilder(this.locale).get("notification.lockdown"));
            throw r;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerLoginEvent e) {
        try (TransactionLayer tx = this.transactor.transact();){
            this.onJoin(e.getPlayer(), e.getAddress().getHostAddress());
        }
        catch (RejectedException r) {
            e.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            e.setKickMessage(r.getMessage(this.locale));
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "An error occurred when a player tried to join", t);
            throw t;
        }
    }

    public void onChat(Player player) throws RejectedException {
        User user = this.userService.getOrCreate(player);
        try {
            this.userService.onChat(user);
        }
        catch (RejectedException r) {
            r.with("name", player.getName());
            this.broadcastService.moderators("muted", Duration.ofMinutes(3L), r.toBuilder(this.locale).get("notification.muted"));
            throw r;
        }
        try {
            this.addressService.onChat(this.addressService.getOrCreate(player.getAddress().getAddress().getHostAddress()));
        }
        catch (RejectedException r) {
            r.with("name", player.getName());
            this.broadcastService.moderators("muted", Duration.ofMinutes(3L), r.toBuilder(this.locale).get("notification.ipmuted"));
            throw r;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        try (TransactionLayer tx = this.transactor.transact();){
            this.onChat(e.getPlayer());
        }
        catch (RejectedException r) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(r.getMessage(this.locale));
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "An error occurred when a player tried to chat", t);
            throw t;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        try (TransactionLayer tx = this.transactor.transact();){
            if (!this.userService.isChatCommand(e.getMessage())) {
                return;
            }
            this.onChat(e.getPlayer());
        }
        catch (RejectedException r) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(r.getMessage(this.locale));
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "An error occurred when a player tried to use a command", t);
            throw t;
        }
    }
}

