/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.locale;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.ocpsoft.prettytime.PrettyTime;
import org.ocpsoft.prettytime.units.JustNow;

public class Locale {
    protected HashMap<String, String> messages;
    protected PrettyTime prettyTime = new PrettyTime(java.util.Locale.ENGLISH);

    public Locale() {
        this.messages = new HashMap();
        this.prettyTime.removeUnit(JustNow.class);
    }

    public Locale(Map<String, String> messages) {
        this();
        this.messages = new HashMap<String, String>(messages);
    }

    public Locale(ConfigurationSection config) {
        this();
        this.load(config);
    }

    public void load(ConfigurationSection config) {
        this.messages = new HashMap();
        for (String key : config.getKeys(true)) {
            String value = config.getString(key);
            this.messages.put(key, value);
        }
        String locale = config.getString("locale");
        if (locale != null) {
            this.setLocale(locale);
        }
    }

    public void setLocale(String locale) {
        this.prettyTime.setLocale(java.util.Locale.forLanguageTag(locale));
    }

    public String getLocale() {
        return this.prettyTime.getLocale().toString();
    }

    public MessageBuilder get() {
        return new MessageBuilder(this);
    }

    public void put(String key, String template) {
        this.messages.put(key, template);
    }

    public boolean has(String message) {
        return this.messages.containsKey(message);
    }
}

