/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.locale;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.util.StringUtil;

public class MessageBuilder {
    private Locale locale;
    private Map<String, Object> substitutions = new HashMap<String, Object>(6);

    public MessageBuilder(Locale locale) {
        this.locale = locale;
    }

    public MessageBuilder with(String key, Object value) {
        this.substitutions.put(key, value);
        return this;
    }

    public Object preview(String key) {
        return this.substitutions.get(key);
    }

    public String get(String name) {
        String template = this.locale.messages.get(name);
        if (template == null) {
            throw new IllegalArgumentException("No such template: " + name);
        }
        HashMap<String, Object> preprocessed = new HashMap<String, Object>(this.substitutions.size());
        for (Map.Entry<String, Object> entry : this.substitutions.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Instant) {
                value = Date.from((Instant)value);
            }
            if (value instanceof Date) {
                value = this.locale.prettyTime.format((Date)value);
            }
            if (value instanceof Duration) {
                Duration d = (Duration)value;
                Instant duration = Instant.now().plus(d);
                value = this.locale.prettyTime.format(Date.from(duration));
            }
            preprocessed.put(key, value);
        }
        template = ChatColor.translateAlternateColorCodes((char)'&', (String)template);
        return StringUtil.expand(template, preprocessed);
    }
}

