/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.orm;

import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.maxgamer.javax.persistence.CascadeType;
import org.maxgamer.javax.persistence.Column;
import org.maxgamer.javax.persistence.Entity;
import org.maxgamer.javax.persistence.Id;
import org.maxgamer.javax.persistence.JoinColumn;
import org.maxgamer.javax.persistence.JoinTable;
import org.maxgamer.javax.persistence.ManyToMany;
import org.maxgamer.javax.persistence.OneToMany;
import org.maxgamer.javax.persistence.OrderBy;
import org.maxgamer.javax.persistence.Table;
import org.maxgamer.maxbans.orm.Ban;
import org.maxgamer.maxbans.orm.Mute;
import org.maxgamer.maxbans.orm.Tenant;
import org.maxgamer.maxbans.orm.UserAddress;
import org.maxgamer.maxbans.orm.Warning;

@Entity
@Table(name="Users")
public class User
implements Tenant {
    @Id
    private UUID id;
    @Column
    private String name;
    @Column
    private String alias;
    @Column(name="first_active")
    private Instant firstActive;
    @Column(name="last_active")
    private Instant lastActive;
    @ManyToMany
    @JoinTable(name="Users_Mute", inverseJoinColumns={@JoinColumn(name="mute_id")}, joinColumns={@JoinColumn(name="user_id")})
    private List<Mute> mutes = new LinkedList<Mute>();
    @ManyToMany
    @JoinTable(name="Users_Ban", inverseJoinColumns={@JoinColumn(name="ban_id")}, joinColumns={@JoinColumn(name="user_id")})
    private List<Ban> bans = new LinkedList<Ban>();
    @OneToMany(mappedBy="id.user", cascade={CascadeType.ALL})
    @OrderBy(value="lastActive ASC")
    private List<UserAddress> addresses = new LinkedList<UserAddress>();
    @OneToMany(mappedBy="user")
    @OrderBy(value="expiresAt")
    private List<Warning> warnings = new LinkedList<Warning>();

    public User() {
    }

    public User(UUID id, String name) {
        this.lastActive = this.firstActive = Instant.now();
        this.id = id;
        this.name = name;
        this.alias = name.toLowerCase();
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.alias = name.toLowerCase();
    }

    public Instant getLastActive() {
        return this.lastActive;
    }

    public void setLastActive(Instant lastActive) {
        this.lastActive = lastActive;
    }

    public List<Mute> getMutes() {
        return this.mutes;
    }

    public List<Ban> getBans() {
        return this.bans;
    }

    public List<UserAddress> getAddresses() {
        return this.addresses;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public Instant getFirstActive() {
        return this.firstActive;
    }

    public void setFirstActive(Instant firstActive) {
        this.firstActive = firstActive;
    }

    public String getAlias() {
        return this.alias;
    }

    public UserAddress getLastAddress() {
        if (this.addresses.isEmpty()) {
            return null;
        }
        return this.addresses.get(this.addresses.size() - 1);
    }
}

