/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.orm;

import java.time.Instant;
import org.maxgamer.javax.persistence.Column;
import org.maxgamer.javax.persistence.EmbeddedId;
import org.maxgamer.javax.persistence.Entity;
import org.maxgamer.javax.persistence.Table;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.orm.id.UserAddressId;

@Entity
@Table(name="Address_User")
public class UserAddress {
    @EmbeddedId
    private UserAddressId id;
    @Column(name="first_active")
    private Instant firstActive;
    @Column(name="last_active")
    private Instant lastActive;

    public UserAddress() {
    }

    public UserAddress(User user, Address address) {
        this(new UserAddressId(user, address));
    }

    public UserAddress(UserAddressId id) {
        this.id = id;
        this.firstActive = Instant.now();
        this.lastActive = Instant.now();
    }

    public User getUser() {
        return this.id.getUser();
    }

    public Address getAddress() {
        return this.id.getAddress();
    }

    public Instant getFirstActive() {
        return this.firstActive;
    }

    public void setFirstActive(Instant firstActive) {
        this.firstActive = firstActive;
    }

    public Instant getLastActive() {
        return this.lastActive;
    }

    public void setLastActive(Instant lastActive) {
        this.lastActive = lastActive;
    }
}

