/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.repository;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.maxgamer.maxbans.transaction.TransactionLayer;
import org.maxgamer.maxbans.transaction.Transactor;

public abstract class Repository<ID extends Serializable, T> {
    protected final Class<ID> idClass;
    protected final Class<T> entityClass;
    @Inject
    protected Transactor worker;

    public Repository(Class<ID> idClass, Class<T> entityClass) {
        this.idClass = idClass;
        this.entityClass = entityClass;
    }

    public T find(ID id) {
        try (TransactionLayer tx = this.worker.transact();){
            T t = tx.getEntityManager().find(this.entityClass, id);
            return t;
        }
    }

    public void persist(T t) {
        try (TransactionLayer tx = this.worker.transact();){
            tx.getEntityManager().persist(t);
        }
    }

    public void save(T t) {
        try (TransactionLayer tx = this.worker.transact();){
            tx.getEntityManager().persist(t);
        }
    }

    public List<T> findAll() {
        try (TransactionLayer tx = this.worker.transact();){
            List<T> list = tx.getEntityManager().createQuery("e", this.entityClass).getResultList();
            return list;
        }
    }

    public Transactor getWorker() {
        return this.worker;
    }
}

