/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.maxgamer.maxbans.event.BanAddressEvent;
import org.maxgamer.maxbans.event.MuteAddressEvent;
import org.maxgamer.maxbans.event.UnbanAddressEvent;
import org.maxgamer.maxbans.event.UnmuteAddressEvent;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.Ban;
import org.maxgamer.maxbans.orm.Mute;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.orm.UserAddress;
import org.maxgamer.maxbans.repository.AddressRepository;
import org.maxgamer.maxbans.repository.BanRepository;
import org.maxgamer.maxbans.repository.MuteRepository;
import org.maxgamer.maxbans.service.EventService;
import org.maxgamer.maxbans.service.GeoIPService;
import org.maxgamer.maxbans.util.RestrictionUtil;
import org.maxgamer.maxbans.util.geoip.GeoCountry;

public class AddressService {
    private BanRepository bans;
    private MuteRepository mutes;
    private AddressRepository addressRepository;
    private GeoIPService geoIPService;
    private EventService eventService;

    @Inject
    public AddressService(BanRepository bans, MuteRepository mutes, AddressRepository addressRepository, GeoIPService geoIPService, EventService eventService) {
        this.bans = bans;
        this.mutes = mutes;
        this.addressRepository = addressRepository;
        this.geoIPService = geoIPService;
        this.eventService = eventService;
    }

    public Address get(String ip) {
        return (Address)this.addressRepository.find(ip);
    }

    public Address getOrCreate(String ip) {
        Address address = this.get(ip);
        if (address != null) {
            return address;
        }
        return this.create(ip);
    }

    public Address create(String ip) {
        Address address = new Address(ip);
        this.addressRepository.save(address);
        return address;
    }

    public Ban getBan(Address address) {
        for (Ban ban : address.getBans()) {
            if (!RestrictionUtil.isActive(ban)) continue;
            return ban;
        }
        return null;
    }

    public Mute getMute(Address address) {
        for (Mute mute : address.getMutes()) {
            if (!RestrictionUtil.isActive(mute)) continue;
            return mute;
        }
        return null;
    }

    public void mute(User source, Address address, String reason, Duration duration) throws RejectedException, CancelledException {
        Mute mute = new Mute();
        mute.setCreated(Instant.now());
        mute.setReason(reason);
        mute.setSource(source);
        if (duration != null) {
            mute.setExpiresAt((Instant)duration.addTo(mute.getCreated()));
        }
        RestrictionUtil.assertRestrictionLonger(address.getMutes(), mute);
        MuteAddressEvent event = new MuteAddressEvent(source, address, mute);
        this.eventService.call(event);
        if (event.isCancelled()) {
            throw new CancelledException();
        }
        RestrictionUtil.assertRestrictionLonger(address.getMutes(), mute);
        this.mutes.save(mute);
        address.getMutes().add(mute);
    }

    public void ban(User source, Address address, String reason, Duration duration) throws RejectedException, CancelledException {
        Ban ban = new Ban();
        ban.setCreated(Instant.now());
        ban.setReason(reason);
        ban.setSource(source);
        if (duration != null) {
            ban.setExpiresAt((Instant)duration.addTo(ban.getCreated()));
        }
        RestrictionUtil.assertRestrictionLonger(address.getBans(), ban);
        BanAddressEvent event = new BanAddressEvent(source, address, ban);
        this.eventService.call(event);
        if (event.isCancelled()) {
            throw new CancelledException();
        }
        this.bans.save(ban);
        address.getBans().add(ban);
    }

    public void unmute(User source, Address address) throws RejectedException, CancelledException {
        List<Mute> list = address.getMutes();
        if (!RestrictionUtil.isActive(list)) {
            throw new RejectedException("mute.error.not-muted").with("address", address.getHost());
        }
        ArrayList<Mute> enforced = new ArrayList<Mute>(list.size());
        for (Mute mute : list) {
            if (!RestrictionUtil.isActive(mute)) continue;
            UnmuteAddressEvent event = new UnmuteAddressEvent(source, address, mute);
            this.eventService.call(event);
            if (event.isCancelled()) {
                throw new CancelledException();
            }
            enforced.add(mute);
        }
        for (Mute mute : enforced) {
            mute.setRevokedAt(Instant.now());
            mute.setRevoker(source);
        }
    }

    public void unban(User source, Address address) throws RejectedException, CancelledException {
        List<Ban> list = address.getBans();
        if (!RestrictionUtil.isActive(list)) {
            throw new RejectedException("ban.error.not-banned").with("address", address.getHost());
        }
        ArrayList<Ban> revocable = new ArrayList<Ban>(list.size());
        for (Ban ban : list) {
            if (!RestrictionUtil.isActive(ban)) continue;
            UnbanAddressEvent event = new UnbanAddressEvent(source, address, ban);
            this.eventService.call(event);
            if (event.isCancelled()) {
                throw new CancelledException();
            }
            revocable.add(ban);
        }
        for (Ban ban : revocable) {
            ban.setRevokedAt(Instant.now());
            ban.setRevoker(source);
        }
    }

    public void onChat(Address address) throws RejectedException {
        Mute mute = this.getMute(address);
        if (mute == null) {
            return;
        }
        throw new RejectedException("mute.denied").with("address", address.getHost()).with("banner", mute.getSource() == null ? "Console" : mute.getSource().getName()).with("reason", mute.getReason()).with("duration", mute.getExpiresAt());
    }

    public void onJoin(User user, String ip) throws RejectedException {
        Ban ban;
        Address address = (Address)this.addressRepository.find(ip);
        UserAddress userAddress = null;
        if (address == null) {
            address = this.create(ip);
        } else {
            for (UserAddress history : user.getAddresses()) {
                if (!history.getAddress().getHost().equals(address.getHost())) continue;
                userAddress = history;
            }
        }
        if (userAddress == null) {
            userAddress = new UserAddress(user, address);
        }
        if ((ban = this.getBan(address)) != null) {
            throw new RejectedException("ipban.denied").with("address", ip).with("name", user.getName()).with("source", ban.getSource() == null ? "Console" : ban.getSource().getName()).with("reason", ban.getReason()).with("duration", ban.getExpiresAt());
        }
        userAddress.setLastActive(Instant.now());
        user.getAddresses().add(userAddress);
    }

    public MessageBuilder report(Address address, Locale locale) throws RejectedException {
        Mute mute;
        Ban ban;
        GeoCountry country;
        if (address == null) {
            throw new RejectedException("iplookup.never");
        }
        List<UserAddress> history = address.getUsers();
        MessageBuilder builder = locale.get();
        builder.with("ip", address.getHost());
        if (!history.isEmpty()) {
            Instant lastActive = null;
            Instant firstActive = null;
            for (UserAddress userAddress : history) {
                if (lastActive == null || userAddress.getLastActive().isAfter(lastActive)) {
                    lastActive = userAddress.getLastActive();
                }
                if (firstActive != null && !userAddress.getFirstActive().isBefore(firstActive)) continue;
                firstActive = userAddress.getFirstActive();
            }
            builder.with("lastActive", lastActive);
            builder.with("firstActive", firstActive);
        }
        if ((country = this.geoIPService.getCountry(address.getHost())) != null) {
            builder.with("country", country.getCountryName());
            builder.with("continent", country.getContinentName());
        }
        if ((ban = this.getBan(address)) != null) {
            String reason = ban.getReason();
            if (reason == null || reason.isEmpty()) {
                reason = "No reason";
            }
            builder.with("ban", reason);
            builder.with("ban.reason", reason);
            builder.with("ban.source", ban.getSource() == null ? "Console" : ban.getSource().getName());
            builder.with("ban.expires", ban.getExpiresAt());
            builder.with("ban.created", ban.getCreated());
        }
        if ((mute = this.getMute(address)) != null) {
            String reason = mute.getReason();
            if (reason == null || reason.isEmpty()) {
                reason = "No reason";
            }
            builder.with("mute", reason);
            builder.with("mute.reason", reason);
            builder.with("mute.source", mute.getSource() == null ? "Console" : mute.getSource().getName());
            builder.with("mute.expires", mute.getExpiresAt());
            builder.with("mute.created", mute.getCreated());
        }
        List users = address.getUsers().stream().map(UserAddress::getUser).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        for (User related : users) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(related.getName());
        }
        builder.with("users", stringBuilder.toString());
        return builder;
    }
}

