/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.util.Permissions;

public class BroadcastService {
    private static final String MODERATOR_PERMISSION = "maxbans.mod";
    private Server server;
    private Map<Object, Instant> firewall = new HashMap<Object, Instant>();
    private Locale locale;

    @Inject
    public BroadcastService(Server server, Locale locale) {
        this.server = server;
        this.locale = locale;
    }

    public void moderators(String message) {
        this.server.broadcast(message, MODERATOR_PERMISSION);
    }

    public void broadcast(String message, boolean silent, CommandSender ... required) {
        String permission;
        if (silent) {
            permission = Permissions.SEE_SILENT;
            if (this.locale.has("silent.prefix")) {
                message = this.locale.get().get("silent.prefix") + message;
            }
            if (this.locale.has("silent.suffix")) {
                message = message + this.locale.get().get("silent.suffix");
            }
        } else {
            permission = Permissions.SEE_BROADCAST;
        }
        this.server.broadcast(message, permission);
        for (CommandSender involved : required) {
            if (involved == null || involved.hasPermission(permission)) continue;
            involved.sendMessage(message);
        }
    }

    public void moderators(Object key, Duration timeout, String message) {
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        if (key instanceof Player) {
            throw new IllegalArgumentException("Players make bad keys");
        }
        Instant old = this.firewall.get(key);
        if (old != null && old.plus(timeout).isAfter(Instant.now())) {
            return;
        }
        this.firewall.put(key, Instant.now().plus(timeout));
        this.moderators(message);
    }
}

