/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.maxgamer.javax.persistence.criteria.CriteriaBuilder;
import org.maxgamer.javax.persistence.criteria.CriteriaQuery;
import org.maxgamer.javax.persistence.criteria.Expression;
import org.maxgamer.javax.persistence.criteria.Root;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.Ban;
import org.maxgamer.maxbans.orm.Mute;
import org.maxgamer.maxbans.orm.Restriction;
import org.maxgamer.maxbans.orm.Tenant;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.orm.Warning;
import org.maxgamer.maxbans.transaction.TransactionLayer;
import org.maxgamer.maxbans.transaction.Transactor;
import org.maxgamer.maxbans.util.MessageUtil;

public class HistoryService {
    private static final int LIMIT = 15;
    private Transactor transactor;
    private Locale locale;

    @Inject
    public HistoryService(Transactor transactor, Locale locale) {
        this.transactor = transactor;
        this.locale = locale;
    }

    public List<String> getHistory(int page, User source) {
        try (TransactionLayer tx = this.transactor.transact();){
            List<String> list = this.describe(this.getBySender(page, source));
            return list;
        }
    }

    public List<String> getHistory(int page) {
        try (TransactionLayer tx = this.transactor.transact();){
            List<String> list = this.describe(this.getAll(page));
            return list;
        }
    }

    private List<Restriction> getBySender(int page, User user) {
        try (TransactionLayer tx = this.transactor.transact();){
            CriteriaBuilder cb = tx.getEntityManager().getCriteriaBuilder();
            CriteriaQuery<Restriction> query = cb.createQuery(Restriction.class);
            Root<Restriction> root = query.from(Restriction.class);
            if (user != null) {
                query.where((Expression)cb.equal(root.get("source"), user));
            } else {
                query.where((Expression)cb.isNull(root.get("source")));
            }
            query.orderBy(cb.desc(root.get("created")));
            List<Restriction> list = tx.getEntityManager().createQuery(query).setFirstResult(page * 15).setMaxResults(15).getResultList();
            return list;
        }
    }

    private List<Restriction> getAll(int page) {
        try (TransactionLayer tx = this.transactor.transact();){
            CriteriaBuilder cb = tx.getEntityManager().getCriteriaBuilder();
            CriteriaQuery<Restriction> query = cb.createQuery(Restriction.class);
            Root<Restriction> root = query.from(Restriction.class);
            query.orderBy(cb.desc(root.get("created")));
            List<Restriction> list = tx.getEntityManager().createQuery(query).setFirstResult(page * 15).setMaxResults(15).getResultList();
            return list;
        }
    }

    private List<String> describe(List<Restriction> restrictions) {
        ArrayList<String> messages = new ArrayList<String>(restrictions.size());
        for (Restriction restriction : restrictions) {
            MessageBuilder builder = this.contextualise(restriction);
            String message = this.get(builder, restriction);
            messages.add(message);
        }
        return messages;
    }

    private MessageBuilder contextualise(Restriction restriction) {
        Tenant tenant = restriction.getTenant();
        MessageBuilder builder = this.locale.get();
        MessageUtil.inject(builder, tenant);
        MessageUtil.inject(builder, restriction);
        return builder;
    }

    private String get(MessageBuilder builder, Restriction restriction) {
        if (restriction instanceof Mute) {
            return builder.get("history.mute");
        }
        if (restriction instanceof Ban) {
            return builder.get("history.ban");
        }
        if (restriction instanceof Warning) {
            return builder.get("history.warn");
        }
        throw new IllegalArgumentException("No such restriction type registered: " + restriction);
    }
}

