/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.UserService;

public class LocatorService {
    private Server server;
    private UserService userService;

    @Inject
    public LocatorService(Server server, UserService userService) {
        this.server = server;
        this.userService = userService;
    }

    public User user(String name) {
        User user = this.userService.get(name);
        if (user != null) {
            return user;
        }
        user = this.userService.get(name + "%");
        if (user != null) {
            return user;
        }
        Player p = this.server.getPlayerExact(name);
        if (p != null) {
            user = this.userService.getOrCreate(p);
            return user;
        }
        p = this.server.getPlayer(name);
        if (p != null) {
            user = this.userService.getOrCreate(p);
            return user;
        }
        return null;
    }

    public Player player(User user) {
        if (user == null) {
            return null;
        }
        return this.server.getPlayer(user.getId());
    }

    public Player player(String name) {
        return this.server.getPlayer(name);
    }

    public List<Player> players(Address address) {
        LinkedList<Player> list = new LinkedList<Player>();
        for (Player player : this.server.getOnlinePlayers()) {
            if (!player.getAddress().getAddress().getHostAddress().equals(address.getHost())) continue;
            list.add(player);
        }
        return list;
    }
}

