/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.service.BroadcastService;
import org.maxgamer.maxbans.service.UserService;
import org.maxgamer.maxbans.util.Lockdown;

public class LockdownService {
    private Server server;
    private UserService userService;
    private BroadcastService broadcastService;
    private FileConfiguration file;
    private Lockdown state;
    private String reason;

    @Inject
    public LockdownService(Server server, UserService userService, BroadcastService broadcastService, FileConfiguration file) {
        this.server = server;
        this.userService = userService;
        this.broadcastService = broadcastService;
        this.file = file;
        String type = file.getString("state", "off");
        if (type != null) {
            this.state = Lockdown.get(type);
        }
        if (this.state == null) {
            this.state = Lockdown.OFF;
        }
        this.reason = file.getString("reason");
    }

    public void onJoin(User user) throws RejectedException {
        if (this.isAllowed(user, true)) {
            return;
        }
        throw new RejectedException("lockdown.message").with("reason", this.reason);
    }

    public boolean isAllowed(User user, boolean isJoining) {
        switch (this.state) {
            case ALL: {
                return false;
            }
            case JOIN: {
                return !isJoining;
            }
            case NEW: {
                return user.getFirstActive().isBefore(this.newQualifier());
            }
            case OFF: {
                return true;
            }
        }
        return true;
    }

    public MessageBuilder lockdown(User source, String name, String reason, Locale locale) throws RejectedException {
        Lockdown type = Lockdown.get(name);
        if (type == null) {
            throw new RejectedException("No such lockdown: " + name + ", options are: " + Arrays.toString((Object[])Lockdown.values()));
        }
        if (source != null && !this.isAllowed(source, false)) {
            throw new RejectedException("That would prevent you from logging back in: You wouldn't be able to turn the lockdown off! Only console users may do that.");
        }
        this.state = type;
        this.reason = reason;
        this.file.set("state", (Object)this.state.toString());
        this.file.set("reason", (Object)reason);
        MessageBuilder message = locale.get().with("type", this.state.toString().toLowerCase()).with("reason", reason).with("description", this.state.description()).with("source", source == null ? "Console" : source.getName());
        if (type == Lockdown.ALL || type == Lockdown.NEW) {
            for (Player player : this.server.getOnlinePlayers()) {
                User user = this.userService.getOrCreate(player);
                if (this.isAllowed(user, false)) continue;
                player.kickPlayer(message.get("lockdown.message"));
            }
        }
        return message;
    }

    public Instant newQualifier() {
        return Instant.now().minus(30L, ChronoUnit.MINUTES);
    }

    public Lockdown getState() {
        return this.state;
    }
}

