/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.bukkit.entity.Player;
import org.maxgamer.maxbans.config.PluginConfig;
import org.maxgamer.maxbans.event.BanUserEvent;
import org.maxgamer.maxbans.event.MuteUserEvent;
import org.maxgamer.maxbans.event.UnbanUserEvent;
import org.maxgamer.maxbans.event.UnmuteUserEvent;
import org.maxgamer.maxbans.exception.CancelledException;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.locale.Locale;
import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.Ban;
import org.maxgamer.maxbans.orm.Mute;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.orm.UserAddress;
import org.maxgamer.maxbans.repository.BanRepository;
import org.maxgamer.maxbans.repository.MuteRepository;
import org.maxgamer.maxbans.repository.UserRepository;
import org.maxgamer.maxbans.service.EventService;
import org.maxgamer.maxbans.util.RestrictionUtil;

public class UserService {
    private PluginConfig config;
    private UserRepository users;
    private BanRepository bans;
    private MuteRepository mutes;
    private EventService events;

    @Inject
    public UserService(PluginConfig config, EventService events, UserRepository users, BanRepository bans, MuteRepository mutes) {
        this.config = config;
        this.events = events;
        this.users = users;
        this.bans = bans;
        this.mutes = mutes;
    }

    public User get(String name) {
        return this.users.findByAlias(name);
    }

    public User get(UUID id) {
        return (User)this.users.find(id);
    }

    public User create(UUID id, String name, Instant lastPlayed) {
        User user = new User(id, name);
        user.setLastActive(lastPlayed);
        this.users.save(user);
        return user;
    }

    public User create(Player player) {
        UUID id = this.config.isOffline() ? UUID.randomUUID() : player.getUniqueId();
        return this.create(id, player.getName(), Instant.ofEpochMilli(player.getLastPlayed()));
    }

    public User get(Player player) {
        if (this.config.isOffline()) {
            return this.get(player.getName());
        }
        return this.get(player.getUniqueId());
    }

    public User getOrCreate(Player player) {
        User user = this.get(player);
        if (user != null) {
            if (!player.getName().equals(user.getName())) {
                user.setName(player.getName());
            }
            return user;
        }
        return this.create(player);
    }

    public Ban getBan(User user) {
        for (Ban ban : user.getBans()) {
            if (!RestrictionUtil.isActive(ban)) continue;
            return ban;
        }
        return null;
    }

    public Mute getMute(User user) {
        for (Mute mute : user.getMutes()) {
            if (!RestrictionUtil.isActive(mute)) continue;
            return mute;
        }
        return null;
    }

    public void onJoin(User user) throws RejectedException {
        Ban ban = this.getBan(user);
        if (ban != null) {
            throw new RejectedException("ban.denied").with("name", user.getName()).with("reason", ban.getReason()).with("source", ban.getSource() == null ? "Console" : ban.getSource().getName()).with("duration", ban.getExpiresAt());
        }
        user.setLastActive(Instant.now());
    }

    public void onChat(User user) throws RejectedException {
        Mute mute = this.getMute(user);
        if (mute == null) {
            return;
        }
        throw new RejectedException("mute.denied").with("name", user.getName()).with("reason", mute.getReason()).with("source", mute.getSource() == null ? "Console" : mute.getSource().getName()).with("duration", mute.getExpiresAt());
    }

    public boolean isChatCommand(String command) {
        return this.config.getChatCommands().contains(command.toLowerCase());
    }

    public void ban(User source, User user, String reason, Duration duration) throws RejectedException, CancelledException {
        Ban ban = new Ban();
        ban.setCreated(Instant.now());
        ban.setReason(reason);
        ban.setSource(source);
        if (duration != null) {
            ban.setExpiresAt((Instant)duration.addTo(ban.getCreated()));
        }
        RestrictionUtil.assertRestrictionLonger(user.getBans(), ban);
        BanUserEvent event = new BanUserEvent(source, user, ban);
        this.events.call(event);
        if (event.isCancelled()) {
            throw new CancelledException();
        }
        RestrictionUtil.assertRestrictionLonger(user.getBans(), ban);
        this.bans.save(ban);
        user.getBans().add(ban);
    }

    public void mute(User source, User user, String reason, Duration duration) throws RejectedException, CancelledException {
        Mute mute = new Mute();
        mute.setCreated(Instant.now());
        mute.setReason(reason);
        mute.setSource(source);
        if (duration != null) {
            mute.setExpiresAt((Instant)duration.addTo(mute.getCreated()));
        }
        RestrictionUtil.assertRestrictionLonger(user.getMutes(), mute);
        MuteUserEvent event = new MuteUserEvent(source, user, mute);
        this.events.call(event);
        if (event.isCancelled()) {
            throw new CancelledException();
        }
        RestrictionUtil.assertRestrictionLonger(user.getMutes(), mute);
        this.mutes.save(mute);
        user.getMutes().add(mute);
    }

    public void unmute(User source, User user) throws RejectedException, CancelledException {
        List<Mute> list = user.getMutes();
        if (!RestrictionUtil.isActive(list)) {
            throw new RejectedException("mute.error.not-muted").with("name", user.getName());
        }
        ArrayList<Mute> revocable = new ArrayList<Mute>(list.size());
        for (Mute mute : list) {
            if (!RestrictionUtil.isActive(mute)) continue;
            UnmuteUserEvent event = new UnmuteUserEvent(source, user, mute);
            this.events.call(event);
            if (event.isCancelled()) {
                throw new CancelledException();
            }
            revocable.add(mute);
        }
        for (Mute mute : revocable) {
            mute.setRevokedAt(Instant.now());
            mute.setRevoker(source);
        }
    }

    public void unban(User source, User user) throws RejectedException, CancelledException {
        List<Ban> list = user.getBans();
        if (!RestrictionUtil.isActive(list)) {
            throw new RejectedException("ban.error.not-banned").with("name", user.getName());
        }
        ArrayList<Ban> enforced = new ArrayList<Ban>(list.size());
        for (Ban ban : list) {
            if (!RestrictionUtil.isActive(ban)) continue;
            UnbanUserEvent event = new UnbanUserEvent(source, user, ban);
            this.events.call(event);
            if (event.isCancelled()) {
                throw new CancelledException();
            }
            enforced.add(ban);
        }
        for (Ban ban : enforced) {
            if (!RestrictionUtil.isActive(ban)) continue;
            ban.setRevokedAt(Instant.now());
            ban.setRevoker(source);
        }
    }

    public MessageBuilder report(User user, Locale locale) throws RejectedException {
        Mute mute;
        Ban ban;
        if (user == null || user.getAddresses().isEmpty()) {
            throw new RejectedException("iplookup.never");
        }
        MessageBuilder builder = locale.get();
        builder.with("name", user.getName());
        builder.with("firstActive", user.getFirstActive());
        builder.with("lastActive", user.getLastActive());
        UserAddress lastAddress = user.getLastAddress();
        if (lastAddress != null) {
            builder.with("ip", lastAddress.getAddress().getHost());
        }
        if ((ban = this.getBan(user)) != null) {
            String reason = ban.getReason();
            if (reason == null || reason.isEmpty()) {
                reason = "No reason";
            }
            builder.with("ban", reason);
            builder.with("ban.reason", reason);
            builder.with("ban.source", ban.getSource() == null ? "Console" : ban.getSource().getName());
            builder.with("ban.expires", ban.getExpiresAt());
            builder.with("ban.created", ban.getCreated());
        }
        if ((mute = this.getMute(user)) != null) {
            String reason = mute.getReason();
            if (reason == null || reason.isEmpty()) {
                reason = "No reason";
            }
            builder.with("mute", reason);
            builder.with("mute.reason", reason);
            builder.with("mute.source", mute.getSource() == null ? "Console" : mute.getSource().getName());
            builder.with("mute.expires", mute.getExpiresAt());
            builder.with("mute.created", mute.getCreated());
        }
        ArrayList<String> addresses = new ArrayList<String>(user.getAddresses().size());
        for (UserAddress userAddress : user.getAddresses()) {
            addresses.add(userAddress.getAddress().getHost());
        }
        Collections.reverse(addresses);
        builder.with("addresses", addresses);
        return builder;
    }
}

