/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.service.metric;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.bukkit.plugin.Plugin;
import org.maxgamer.maxbans.MaxBansPlus;
import org.maxgamer.maxbans.bstats.bukkit.Metrics;
import org.maxgamer.maxbans.service.metric.MetricService;

public class BStatsMetricService
implements MetricService {
    public static final int MAXBANS_PLUS_PLUGIN_ID = 829;
    private Map<String, Integer> increments = new HashMap<String, Integer>();

    @Inject
    public BStatsMetricService(MaxBansPlus plugin) {
        Metrics metrics = new Metrics((Plugin)plugin, 829);
        metrics.addCustomChart(new Metrics.SimplePie("locale", () -> plugin.getLocale().getLocale()));
        metrics.addCustomChart(new Metrics.SingleLineChart("user_bans", this.getAndReset("user_bans")));
        metrics.addCustomChart(new Metrics.SingleLineChart("user_mutes", this.getAndReset("user_mutes")));
        metrics.addCustomChart(new Metrics.SingleLineChart("ip_bans", this.getAndReset("ip_bans")));
        metrics.addCustomChart(new Metrics.SingleLineChart("ip_mutes", this.getAndReset("ip_mutes")));
        metrics.addCustomChart(new Metrics.SingleLineChart("warnings", this.getAndReset("warnings")));
        metrics.addCustomChart(new Metrics.SingleLineChart("kicks", this.getAndReset("kicks")));
    }

    protected Callable<Integer> getAndReset(String key) {
        return () -> {
            Integer v = this.increments.remove(key);
            if (v == null) {
                return 0;
            }
            return v;
        };
    }

    public int get(String key) {
        Integer v = this.increments.get(key);
        if (v == null) {
            return 0;
        }
        return v;
    }

    @Override
    public void increment(String chartId) {
        int value = this.get(chartId) + 1;
        this.increments.put(chartId, value);
    }
}

