/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.transaction;

import java.io.Closeable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.maxgamer.javax.persistence.EntityManager;
import org.maxgamer.maxbans.exception.TransactionException;

public class TransactionLayer
implements Closeable {
    private ThreadLocal<Session> sessions;
    private Session session;
    private Transaction transaction;
    private boolean opened;

    public TransactionLayer(ThreadLocal<Session> sessions, SessionFactory factory) {
        this.sessions = sessions;
        this.session = sessions.get();
        if (this.session == null) {
            this.session = factory.openSession();
            sessions.set(this.session);
            this.transaction = this.session.beginTransaction();
            this.opened = true;
        } else {
            this.opened = false;
        }
    }

    public EntityManager getEntityManager() {
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isRoot() {
        return this.opened;
    }

    @Override
    public void close() {
        if (!this.opened) {
            return;
        }
        try {
            this.session.flush();
        }
        catch (Throwable t) {
            this.transaction.rollback();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new TransactionException(t);
        }
        finally {
            this.sessions.set(null);
            if (this.transaction.getStatus() != TransactionStatus.ROLLED_BACK) {
                this.transaction.commit();
            }
            this.session.close();
        }
    }
}

