/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import java.util.ArrayList;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.BaseFlywayCallback;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.maxgamer.maxbans.config.JdbcConfig;
import org.maxgamer.maxbans.util.db.BotchedUninstallDetectionCallback;
import org.maxgamer.maxbans.util.db.Flyway_MySQL_V1_1__Fix_Callback;

public class FlywayUtil {
    public static Flyway migrater(JdbcConfig jdbc) {
        Flyway flyway = new Flyway();
        flyway.setClassLoader(Flyway.class.getClassLoader());
        flyway.setDataSource(jdbc.getUrl(), jdbc.getUsername(), jdbc.getPassword(), new String[0]);
        ArrayList<BaseFlywayCallback> callbacks = new ArrayList<BaseFlywayCallback>();
        String type = "h2";
        if (jdbc.getDriver().contains("mysql")) {
            type = "mysql";
            flyway.setBaselineVersion(MigrationVersion.fromVersion("1.0"));
            flyway.setBaselineOnMigrate(true);
            callbacks.add(new Flyway_MySQL_V1_1__Fix_Callback());
            callbacks.add(new BotchedUninstallDetectionCallback());
        }
        flyway.setCallbacks(callbacks.toArray(new FlywayCallback[callbacks.size()]));
        flyway.setLocations("db/migration/" + type);
        return flyway;
    }
}

