/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import java.util.HashSet;
import java.util.Set;

public enum Lockdown {
    OFF("off", "none", "never", "nobody", "disabled"),
    NEW("new", "recent"),
    JOIN("join", "on", "joining", "login", "enabled"),
    ALL("all", "everyone");

    private Set<String> aliases;

    public static Lockdown get(String name) {
        for (Lockdown l : Lockdown.values()) {
            if (!l.aliases.contains(name.toLowerCase())) continue;
            return l;
        }
        return null;
    }

    private Lockdown(String ... names) {
        this.aliases = new HashSet<String>(names.length);
        for (String s : names) {
            this.aliases.add(s.toLowerCase());
        }
    }

    public String description() {
        switch (this) {
            case ALL: {
                return "All users are kicked and nobody may rejoin";
            }
            case JOIN: {
                return "Currently active users can play, but nobody may join";
            }
            case NEW: {
                return "Accounts created in the last 30 minutes or newly created can't join";
            }
            case OFF: {
                return "Anyone can join";
            }
        }
        return this.name().toString();
    }
}

