/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import org.maxgamer.maxbans.locale.MessageBuilder;
import org.maxgamer.maxbans.orm.Address;
import org.maxgamer.maxbans.orm.Restriction;
import org.maxgamer.maxbans.orm.Tenant;
import org.maxgamer.maxbans.orm.User;
import org.maxgamer.maxbans.orm.UserAddress;

public class MessageUtil {
    public static MessageBuilder inject(MessageBuilder builder, Tenant tenant) {
        if (tenant instanceof User) {
            return MessageUtil.inject(builder, (User)tenant);
        }
        if (tenant instanceof Address) {
            return MessageUtil.inject(builder, (Address)tenant);
        }
        throw new IllegalArgumentException("Unexpected Tenant type: " + tenant);
    }

    public static MessageBuilder inject(MessageBuilder builder, User user) {
        builder.with("id", user.getId());
        builder.with("name", user.getName());
        UserAddress lastAddress = user.getLastAddress();
        if (lastAddress != null) {
            builder.with("address", lastAddress.getAddress().getHost());
        }
        return builder;
    }

    public static MessageBuilder inject(MessageBuilder builder, Address address) {
        builder.with("address", address.getHost());
        return builder;
    }

    public static MessageBuilder inject(MessageBuilder builder, Restriction restriction) {
        builder.with("reason", restriction.getReason());
        builder.with("source", restriction.getSource() == null ? "Console" : restriction.getSource().getName());
        builder.with("duration", restriction.getExpiresAt());
        builder.with("created", restriction.getCreated());
        return builder;
    }

    private MessageUtil() {
    }
}

