/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.maxgamer.maxbans.exception.RejectedException;
import org.maxgamer.maxbans.orm.Restriction;

public class RestrictionUtil {
    public static <R extends Restriction> void assertRestrictionLonger(R existing, R replacement) throws RejectedException {
        if (existing == null) {
            return;
        }
        if (!RestrictionUtil.isActive(existing)) {
            return;
        }
        if (existing.getExpiresAt() == null) {
            throw new RejectedException("Existing restriction lasts longer");
        }
        if (replacement.getExpiresAt() == null) {
            return;
        }
        if (existing.getExpiresAt().isAfter(replacement.getExpiresAt())) {
            throw new RejectedException("Existing restriction lasts longer");
        }
    }

    public static <R extends Restriction> void assertRestrictionLonger(Iterable<R> existingRestrictions, R replacement) throws RejectedException {
        for (Restriction existing : existingRestrictions) {
            RestrictionUtil.assertRestrictionLonger(existing, replacement);
        }
    }

    public static boolean isActive(Restriction r) {
        if (r == null) {
            return false;
        }
        if (r.getRevokedAt() != null) {
            return false;
        }
        if (r.getExpiresAt() == null) {
            return true;
        }
        return r.getExpiresAt().isAfter(Instant.now());
    }

    public static boolean isActive(Iterable<? extends Restriction> restrictions) {
        for (Restriction restriction : restrictions) {
            if (!RestrictionUtil.isActive(restriction)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSilent(LinkedList<String> args) {
        Iterator it = args.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.equalsIgnoreCase("-s")) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static Duration getDuration(LinkedList<String> args) {
        if (args.size() < 2) {
            return null;
        }
        try {
            int value = Integer.valueOf(args.get(0));
            String unitName = args.get(1);
            for (TimeUnit unit : TimeUnit.values()) {
                if (!unit.name().toLowerCase().startsWith(unitName.toLowerCase())) continue;
                args.pop();
                args.pop();
                return Duration.ofMillis(unit.toMillis(value));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private RestrictionUtil() {
        throw new RuntimeException("No constructor");
    }
}

