/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import io.sentry.SentryClient;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.maxgamer.maxbans.MaxBansPlus;

public class SentryLogger
extends Logger {
    private static final String JRE_PROPERTY = "Java-Version";
    private static final HashMap<Level, Event.Level> levels = new HashMap(9);
    private Logger delegate;
    private String platform;
    private String release;
    private String serverName;
    private Event.Level minimum;
    private SentryClient sentry;

    public SentryLogger(MaxBansPlus plugin, Event.Level minimum, SentryClient sentry) {
        this(plugin.getLogger(), plugin.getName(), plugin.getServer().getName() + " " + plugin.getServer().getVersion(), plugin.getDescription().getName() + " " + plugin.getDescription().getVersion(), plugin.getServer().getName(), minimum, sentry);
    }

    public SentryLogger(Logger delegate, String logName, String platform, String release, String serverName, Event.Level minimum, SentryClient sentry) {
        super(logName, null);
        this.delegate = delegate;
        this.platform = platform;
        this.release = release;
        this.serverName = serverName;
        this.minimum = minimum;
        this.sentry = sentry;
    }

    @Override
    public void log(LogRecord record) {
        Event.Level level;
        if (this.delegate != null) {
            this.delegate.log(record);
        }
        if ((level = levels.get(record.getLevel())) == null) {
            return;
        }
        if (level.ordinal() > this.minimum.ordinal()) {
            return;
        }
        EventBuilder builder = new EventBuilder().withMessage(record.getMessage()).withLevel(level);
        if (record.getThrown() != null) {
            builder.withSentryInterface(new ExceptionInterface(record.getThrown()));
        }
        builder.withServerName(this.serverName);
        builder.withPlatform(this.platform);
        builder.withRelease(this.release);
        builder.withTag(JRE_PROPERTY, System.getProperty("java.version"));
        this.sentry.sendEvent(builder.build());
    }

    static {
        levels.put(Level.ALL, Event.Level.DEBUG);
        levels.put(Level.FINEST, Event.Level.DEBUG);
        levels.put(Level.FINER, Event.Level.DEBUG);
        levels.put(Level.FINE, Event.Level.DEBUG);
        levels.put(Level.INFO, Event.Level.INFO);
        levels.put(Level.CONFIG, Event.Level.INFO);
        levels.put(Level.WARNING, Event.Level.WARNING);
        levels.put(Level.SEVERE, Event.Level.ERROR);
        levels.put(Level.OFF, null);
    }
}

