/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static String expand(String template, Map<String, Object> substitutions) {
        String result = "";
        Matcher matcher = Pattern.compile("\\{\\{[^\\}\\}]*\\}\\}").matcher(template);
        int last = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String group = matcher.group();
            result = result + template.substring(last, start);
            last = end;
            group = group.substring(2, group.length() - 2);
            String[] options = StringUtil.split(group, '|');
            String value = StringUtil.expand(options, substitutions);
            result = result + value;
        }
        result = result + template.substring(last);
        return result;
    }

    public static String expand(String[] options, Map<String, Object> substitutions) {
        for (String option : options) {
            String text;
            Object value = substitutions.get(option);
            if (value == null || (text = value.toString()).isEmpty()) continue;
            return text;
        }
        return options[options.length - 1];
    }

    private static String[] split(String text, char delimiter) {
        int end;
        LinkedList<String> components = new LinkedList<String>();
        int start = 0;
        while ((end = text.indexOf(delimiter, start)) >= 0) {
            String s = text.substring(start, end);
            components.add(s);
            start = end + 1;
        }
        components.add(text.substring(start, text.length()));
        return components.toArray(new String[components.size()]);
    }
}

