/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

public class TemporalDuration
implements TemporalAccessor {
    private static final Temporal BASE_TEMPORAL = LocalDateTime.of(0, 1, 1, 0, 0);
    private static final DateTimeFormatter dtf = new DateTimeFormatterBuilder().optionalStart().appendValue(ChronoField.YEAR).appendLiteral(" Years ").optionalEnd().optionalStart().appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral(" Months ").optionalEnd().optionalStart().appendValue(ChronoField.DAY_OF_MONTH).appendLiteral(" Days ").optionalEnd().optionalStart().appendValue(ChronoField.HOUR_OF_DAY).appendLiteral(" Hours ").optionalEnd().optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR).appendLiteral(" Minutes ").optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE).appendLiteral(" Seconds ").optionalEnd().toFormatter();
    private Duration duration;
    private Temporal temporal;

    public static TemporalDuration of(Duration d) {
        if (d == null) {
            return null;
        }
        return new TemporalDuration(d);
    }

    public TemporalDuration(Duration duration) {
        if (duration == null) {
            return;
        }
        this.duration = duration;
        this.temporal = duration.addTo(BASE_TEMPORAL);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (!this.temporal.isSupported(field)) {
            return false;
        }
        long value = this.temporal.getLong(field) - BASE_TEMPORAL.getLong(field);
        return value != 0L;
    }

    @Override
    public long getLong(TemporalField field) {
        if (!this.isSupported(field)) {
            throw new UnsupportedTemporalTypeException(field.toString());
        }
        return this.temporal.getLong(field) - BASE_TEMPORAL.getLong(field);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        if (this.duration == null) {
            return "Never";
        }
        return dtf.format(this).trim();
    }
}

