/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.BaseFlywayCallback;
import org.maxgamer.maxbans.exception.SchemaBrokenException;

public class BotchedUninstallDetectionCallback
extends BaseFlywayCallback {
    public static final String MINIMUM_MIGRATION_VERSION = "1.1";
    public static final String[] REQUIRED_TABLES = new String[]{"Users", "Mute", "Ban", "Address", "Warning"};

    @Override
    public void beforeValidate(Connection connection) {
        String versionTable = this.flywayConfiguration.getTable();
        try (PreparedStatement ps = connection.prepareStatement("SELECT sv.checksum FROM schema_version sv WHERE sv.version = ?");){
            ps.setString(1, MINIMUM_MIGRATION_VERSION);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return;
            }
            for (String requiredTable : REQUIRED_TABLES) {
                try (PreparedStatement check = connection.prepareStatement("SELECT 1 FROM " + requiredTable);){
                    check.execute();
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.contains("doesn't exist") && message.contains(requiredTable)) {
                        throw new SchemaBrokenException("It appears the MaxBans database has been tampered with or improperly uninstalled. The table " + requiredTable + " is missing from the database, but the " + versionTable + " (schema_version) table exists. Deleting the " + versionTable + " table may fix this. Or it'll make your problem worse.", e);
                    }
                    throw new FlywayException("Unexpected SQLException while verifying database integrity", e);
                }
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (message.contains("doesn't exist") && message.contains(versionTable)) {
                return;
            }
            throw new FlywayException("Could not verify " + versionTable + " (schema_version) table exists", e);
        }
    }
}

