/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.BaseFlywayCallback;

public class Flyway_MySQL_V1_1__Fix_Callback
extends BaseFlywayCallback {
    public static final String MIGRATION_VERSION = "1.1";
    private static final long DESIRED_CHECKSUM = -2053758196L;

    @Override
    public void beforeValidate(Connection connection) {
        String versionTable = this.flywayConfiguration.getTable();
        try (PreparedStatement ps = connection.prepareStatement("SELECT sv.checksum FROM schema_version sv WHERE sv.version = ?");){
            ps.setString(1, MIGRATION_VERSION);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return;
            }
            if (rs.getLong("sv.checksum") == -2053758196L) {
                return;
            }
            try (PreparedStatement fix = connection.prepareStatement("UPDATE schema_version SET checksum = ? WHERE version = ?");){
                fix.setLong(1, -2053758196L);
                fix.setString(2, MIGRATION_VERSION);
                fix.execute();
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (message.contains("doesn't exist") && message.contains(versionTable)) {
                return;
            }
            throw new FlywayException("Could not verify first migration checksum", e);
        }
    }
}

