/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util.geoip;

import java.math.BigInteger;
import java.util.Objects;
import org.maxgamer.maxbans.util.geoip.GeoCountry;

public class GeoBlock
implements Comparable<GeoBlock> {
    private final GeoCountry country;
    private final BigInteger minimum;
    private final BigInteger maximum;

    public GeoBlock(GeoCountry country, BigInteger minimum, BigInteger maximum) {
        this.country = country;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public GeoCountry getCountry() {
        return this.country;
    }

    public BigInteger getMinimum() {
        return this.minimum;
    }

    public BigInteger getMaximum() {
        return this.maximum;
    }

    @Override
    public int compareTo(GeoBlock that) {
        return this.minimum.subtract(that.minimum).signum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoBlock geoBlock = (GeoBlock)o;
        return Objects.equals(this.minimum, geoBlock.minimum);
    }

    public int hashCode() {
        return this.minimum.hashCode();
    }

    public String toString() {
        return "GeoBlock{country=" + this.country + ", minimum=" + this.minimum + ", maximum=" + this.maximum + '}';
    }
}

