/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util.geoip;

import com.google.common.net.InetAddresses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.maxgamer.maxbans.util.geoip.GeoBlock;
import org.maxgamer.maxbans.util.geoip.GeoCountry;
import org.maxgamer.maxbans.util.geoip.GeoTable;

public class GeoParser {
    private static final CSVFormat FORMAT = CSVFormat.RFC4180;
    private static final String IPV4_FILE = "GeoLite2-Country-Blocks-IPv4.csv";
    private static final String IPV6_FILE = "GeoLite2-Country-Blocks-IPv6.csv";

    public static GeoTable standard(InputStream geoliteSrc, String localeCode) {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(geoliteSrc);
            String countryFile = "GeoLite2-Country-Locations-" + localeCode + ".csv";
            ByteArrayInputStream countrySrc = null;
            InputStream ipv4Src = null;
            InputStream ipv6Src = null;
            while ((entry = zipInput.getNextEntry()) != null) {
                int n;
                byte[] data;
                ByteArrayOutputStream out;
                if (entry.getName().endsWith(countryFile)) {
                    out = new ByteArrayOutputStream();
                    data = new byte[4096];
                    while ((n = zipInput.read(data)) > 0) {
                        out.write(data, 0, n);
                    }
                    countrySrc = new ByteArrayInputStream(out.toByteArray());
                    continue;
                }
                if (entry.getName().endsWith(IPV4_FILE)) {
                    out = new ByteArrayOutputStream();
                    data = new byte[4096];
                    while ((n = zipInput.read(data)) > 0) {
                        out.write(data, 0, n);
                    }
                    ipv4Src = new ByteArrayInputStream(out.toByteArray());
                    continue;
                }
                if (!entry.getName().endsWith(IPV6_FILE)) continue;
                out = new ByteArrayOutputStream();
                data = new byte[4096];
                while ((n = zipInput.read(data)) > 0) {
                    out.write(data, 0, n);
                }
                ipv6Src = new ByteArrayInputStream(out.toByteArray());
            }
            zipInput.close();
            if (countrySrc == null) {
                throw new FileNotFoundException("Couldn't find " + countryFile + " inside GeoLite");
            }
            if (ipv4Src == null) {
                throw new FileNotFoundException("Couldn't find GeoLite2-Country-Blocks-IPv4.csv inside GeoLite");
            }
            if (ipv6Src == null) {
                throw new FileNotFoundException("Couldn't find GeoLite2-Country-Blocks-IPv6.csv inside GeoLite");
            }
            GeoTable table = new GeoParser().parse(countrySrc, ipv4Src, ipv6Src);
            ((InputStream)countrySrc).close();
            ipv4Src.close();
            ipv6Src.close();
            return table;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't process GeoIP Database", e);
        }
    }

    public GeoTable parse(InputStream countrySrc, InputStream ... blockSrc) throws IOException {
        Map<Integer, GeoCountry> countries = this.countries(countrySrc);
        TreeSet<GeoBlock> blocks = this.blocks(countries, blockSrc);
        return new GeoTable(countries, blocks);
    }

    private Map<Integer, GeoCountry> countries(InputStream countries) throws IOException {
        CSVParser parser = FORMAT.withHeader(new String[0]).parse(new InputStreamReader(countries));
        LinkedHashMap<Integer, GeoCountry> map = new LinkedHashMap<Integer, GeoCountry>();
        for (CSVRecord record : parser) {
            GeoCountry country = this.country(record);
            map.put(country.getId(), country);
        }
        parser.close();
        return map;
    }

    private GeoCountry country(CSVRecord record) {
        int id = Integer.parseInt(record.get("geoname_id"));
        String continentName = record.get("continent_name");
        String continentCode = record.get("continent_code");
        String countryName = record.get("country_name");
        String countryCode = record.get("country_iso_code");
        return new GeoCountry(id, continentName, continentCode, countryName, countryCode);
    }

    private TreeSet<GeoBlock> blocks(Map<Integer, GeoCountry> countries, InputStream ... sources) throws IOException {
        TreeSet<GeoBlock> set = new TreeSet<GeoBlock>();
        for (InputStream blocks : sources) {
            CSVParser parser = FORMAT.withHeader(new String[0]).parse(new InputStreamReader(blocks));
            for (CSVRecord record : parser) {
                GeoBlock block = this.block(countries, record);
                set.add(block);
            }
        }
        return set;
    }

    private GeoBlock block(Map<Integer, GeoCountry> countries, CSVRecord record) throws IOException {
        GeoCountry country;
        String network = record.get("network");
        String[] parts = network.split("/");
        if (parts.length != 2) {
            throw new IOException("Expect 2 network parts: ip/bits, got " + network);
        }
        String ip = parts[0];
        int bits = Integer.parseInt(parts[1]);
        InetAddress addr = InetAddresses.forString((String)ip);
        BigInteger minimum = new BigInteger(addr.getAddress());
        int maxBits = (minimum.toString(2).length() + 7) / 8 * 8 - bits;
        BigInteger mask = BigInteger.ONE.shiftLeft(maxBits).subtract(BigInteger.ONE);
        BigInteger maximum = minimum.or(mask);
        String countryName = record.get("registered_country_geoname_id");
        if (countryName.isEmpty()) {
            countryName = record.get("geoname_id");
        }
        if (!countryName.isEmpty()) {
            int countryId = Integer.parseInt(countryName);
            country = countries.get(countryId);
        } else {
            country = GeoTable.ANONYMOUS;
        }
        return new GeoBlock(country, minimum, maximum);
    }
}

