/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.maxbans.util.geoip;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Map;
import java.util.TreeSet;
import org.maxgamer.maxbans.util.geoip.GeoBlock;
import org.maxgamer.maxbans.util.geoip.GeoCountry;

public class GeoTable {
    public static final GeoCountry ANONYMOUS = new GeoCountry(-1, "Proxy", "NA", "Anonymous", "NA");
    private Map<Integer, GeoCountry> countries;
    private TreeSet<GeoBlock> blocks;

    public GeoTable(Map<Integer, GeoCountry> countries, TreeSet<GeoBlock> blocks) {
        this.countries = countries;
        this.blocks = blocks;
    }

    public GeoBlock getBlock(BigInteger ip) {
        GeoBlock dummy = new GeoBlock(null, ip, ip);
        GeoBlock block = this.blocks.floor(dummy);
        if (block.getMinimum().compareTo(ip) > 0) {
            return null;
        }
        if (block.getMaximum().compareTo(ip) <= 0) {
            return null;
        }
        return block;
    }

    public GeoBlock getBlock(String ip) {
        InetAddress addr = InetAddresses.forString((String)ip);
        return this.getBlock(new BigInteger(addr.getAddress()));
    }
}

